<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Common\Request\UserWs;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Trait UserTypeFields
 * @package Sso\RestBundle\ModelRest\Common\Request\UserWs
 */
trait UserTypeFields
{
    /**
     * @Serializer\SerializedName("email")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank(message = "User Email can not be empty")
     *
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank(message = "Username can not be empty")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("firstname")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank(message = "Firstname can not be empty")
     *
     * @var string
     */
    private $firstName;

    /**
     * @Serializer\SerializedName("lastname")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank(message = "Lastname can not be empty")
     *
     * @var string
     */
    private $lastName;

    /**
     * @Serializer\SerializedName("password")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank(message = "Password can not be empty")
     *
     * @var string
     */
    private $password;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("integer")
     *
     * @Assert\NotBlank(message = "Active can not be empty")
     *
     * @var integer
     */
    private $active;

    /**
     * @Serializer\SerializedName("authId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $authId;

    /**
     * @Serializer\SerializedName("ldapSearchAttribute")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @Serializer\SerializedName("ldapSearchValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return UserTypeFields
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return UserTypeFields
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return UserTypeFields
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
        return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     * @return UserTypeFields
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
        return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return UserTypeFields
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    /**
     * @return integer
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param integer $active
     * @return UserTypeFields
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * @return string
     */
    public function getAuthId()
    {
        return $this->authId;
    }

    /**
     * @param string $authId
     * @return UserTypeFields
     */
    public function setAuthId($authId)
    {
        $this->authId = $authId;
        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchAttributes()
    {
        return $this->ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchAttributes
     * @return UserTypeFields
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;
        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchValue()
    {
        return $this->ldapSearchValue;
    }

    /**
     * @param string $ldapSearchValue
     * @return UserTypeFields
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = $ldapSearchValue;
        return $this;
    }
}
