<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\IdpWs\ServiceUser\Validate;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserIdentifier
 * @package Sso\RestBundle\ModelRest\Request\IdpWs\ServiceUser\Validate
 */
class UserIdentifier
{
    /**
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 128,
     *      max = 128,
     *      minMessage = "Your user must be at least {{ limit }} characters long",
     *      maxMessage = "Your first name cannot be longer than {{ limit }} characters"
     * )
     * @var string
     */
    private $useridentifier;

    /**
     * @Assert\NotBlank()
     * @var string
     */
    private $username;

    /**
     * @param string $username
     * @return UserIdentifier
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $userIdentifier
     * @return UserIdentifier
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->useridentifier = $userIdentifier;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->useridentifier;
    }
}
