<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Add;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class AttributeGroupType
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Add
 */
class AttributeGroupType
{
    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("types")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="id")
     *
     * @var string[]|ArrayCollection
     */
    private $type;

    /**
     * AttributeGroupType constructor.
     */
    public function __construct()
    {
        $this->type = new ArrayCollection();
    }

    /**
     * @param string $name
     * @return AttributeGroupType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string[]|ArrayCollection
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string[]|ArrayCollection $types
     * @return AttributeGroupType
     */
    public function setType($types)
    {
        $this->type = $types;

        return $this;
    }
}
