<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Add;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("attributeGroupAdd")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Add
 */
class Request
{
    /**
     * @Serializer\SerializedName("groups")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Add\AttributeGroupType>")
     * @Serializer\XmlList(entry="attributeGroupType")
     *
     * @var AttributeGroupType[]|ArrayCollection
     */
    private $attributeGroupType;

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->attributeGroupType = new ArrayCollection();
    }

    /**
     * @return AttributeGroupType[]|ArrayCollection
     */
    public function getAttributeGroupType()
    {
        return $this->attributeGroupType;
    }

    /**
     * @param AttributeGroupType $attributeGroupType
     * @return Request
     */
    public function setAttributeGroupType(AttributeGroupType $attributeGroupType)
    {
        if (!$this->attributeGroupType->contains($attributeGroupType)) {
            $this->attributeGroupType->add($attributeGroupType);
        }

        return $this;
    }
}
