<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Update;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("attributeGroupUpdate")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Update
 */
class Request
{
    /**
     * @Serializer\SerializedName("attributeGroups")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Update\AttributeGroup>")
     * @Serializer\XmlList(entry="attributeGroup")
     *
     * @var AttributeGroup[]|ArrayCollection
     */
    private $attributeGroups;

    public function __construct()
    {
        $this->attributeGroups = new ArrayCollection();
    }

    /**
     * @return AttributeGroup[]|ArrayCollection
     */
    public function getAttributeGroups()
    {
        return $this->attributeGroups;
    }

    /**
     * @param AttributeGroup $attributeGroup
     *
     * @return $this
     */
    public function addAttributeGroup(AttributeGroup $attributeGroup)
    {
        if (!$this->attributeGroups->contains($attributeGroup)) {
            $this->attributeGroups->add($attributeGroup);
        }

        return $this;
    }
}
