<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Delete;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 *
 * @Serializer\XmlRoot("item")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Delete
 */
class Item
{
    /**
     * @Serializer\SerializedName("guid")
     * @Serializer\Type("string")
     *
     * @Assert\Length(
     *     min = 36,
     *     max = 36,
     *     minMessage = "Your guid must be {{ limit }} characters long",
     *     maxMessage = "Your guid must be {{ limit }} characters long",
     *     exactMessage = "Your guid must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    protected $guid = '';

    /**
     * @Serializer\SerializedName("referenceId")
     * @Serializer\Type("string")
     *
     * @Assert\Length(
     *     min = 1,
     *     max = 255,
     *     minMessage = "Your reference id must be at least {{ limit }} characters long",
     *     maxMessage = "Your reference id must not be bigger than {{ limit }} characters"
     * )
     *
     * @var string
     */
    protected $referenceId = '';

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     * @return Item
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return Item
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;
        return $this;
    }
}
