<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Object
 *
 * @Serializer\XmlRoot("object")
 * @package Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Update
 */
class Object
{
    /**
     * @Serializer\SerializedName("guid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("referenceId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\SerializedName("typeId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $typeId;

    /**
     * @Serializer\SerializedName("parentGuid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $parentGuid;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $active;

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     * @return $this
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return $this
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

    /**
     * @param string $typeId
     * @return $this
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;
        return $this;
    }

    /**
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * @param string $parentGuid
     * @return $this
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param int $active
     * @return $this
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }
}
