<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectValue\Add;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 *
 * @Serializer\XmlRoot("item")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectValue\Add
 */
class Item
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("objectGuid")
     *
     * @Assert\NotBlank(message = "objectGuid should not be empty")
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "objectGuid must be at least {{ limit }} characters long",
     *      maxMessage = "objectGuid cannot be longer than {{ limit }} characters",
     *      exactMessage = "objectGuid should have exactly {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $objectGuid;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("objectValue")
     *
     * @Assert\NotBlank(message = "objectValue should not be empty")
     *
     * @var string
     */
    private $objectValue;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("languageCode")
     *
     * @Assert\NotBlank(message = "languageCode should not be empty")
     *
     * @var string
     */
    private $languageCode;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("attributeId")
     *
     * @Assert\NotBlank(message = "attributeId should not be empty")
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "attributeId must be at least {{ limit }} characters long",
     *      maxMessage = "attributeId cannot be longer than {{ limit }} characters",
     *      exactMessage = "attributeId should have exactly {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $attributeId;

    /**
     * @return string
     */
    public function getObjectGuid()
    {
        return $this->objectGuid;
    }

    /**
     * @param string $objectGuid
     * @return Item
     */
    public function setObjectGuid($objectGuid)
    {
        $this->objectGuid = $objectGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getObjectValue()
    {
        return $this->objectValue;
    }

    /**
     * @param string $objectValue
     * @return Item
     */
    public function setObjectValue($objectValue)
    {
        $this->objectValue = $objectValue;
        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @param string $languageCode
     * @return Item
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param string $attributeId
     * @return Item
     */
    public function setAttributeId($attributeId)
    {
        $this->attributeId = $attributeId;
        return $this;
    }
}
