<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectValue\Update;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("objectValueUpdate")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectValue\Update
 */
class Request
{
    /**
     * @Serializer\SerializedName("values")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectValue\Update\ObjectValueType>")
     * @Serializer\XmlList(entry="objectValueType")
     *
     * @var ObjectValueType[]|ArrayCollection
     */
    private $objectValueType;

    /**
     * @return ObjectValueType[]|ArrayCollection
     */
    public function getObjectValueType()
    {
        return $this->objectValueType;
    }

    /**
     * @param ObjectValueType $objectValueType
     * @return Request
     */
    public function setObjectValueType(ObjectValueType $objectValueType)
    {
        if (!$this->objectValueType) {
            $this->objectValueType = new ArrayCollection();
        }

        if (!$this->objectValueType->contains($objectValueType)) {
            $this->objectValueType->add($objectValueType);
        }

        return $this;
    }
}
