<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs;

/**
 * Class Factory
 * @package Sso\RestBundle\ModelRest\Request\UserWs
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Version1\Factory
     */
    public function version1()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Version1\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Version2\Factory
     */
    public function version2()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Version2\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
