<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\Application\Delete;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("applicationDelete")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\Application\Delete
 */
class Request
{
    /**
     * @Serializer\SerializedName("applications")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\UserWs\Version1\Application\Delete\Application>")
     * @Serializer\XmlList(entry="application")
     *
     * @var Application[]|ArrayCollection
     */
    private $application;

    /**
     * @return Application[]|ArrayCollection
     */
    public function getApplication()
    {
        return $this->application;
    }

    /**
     * @param Application $application
     * @return Request
     */
    public function setApplication(Application $application)
    {
        if (!$this->application) {
            $this->application = new ArrayCollection();
        }

        if (!$this->application->contains($application)) {
            $this->application->add($application);
        }

        return $this;
    }
}
