<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\ApplicationRole\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("applicationRole")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version1\ApplicationRole\Show
 */
class Request
{
    /**
     * @Serializer\SerializedName("roleName")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $roleName;

    /**
     * @Serializer\SerializedName("applicationName")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $applicationName;

    /**
     * @return string
     */
    public function getRoleName()
    {
        return $this->roleName;
    }

    /**
     * @param string $roleName
     * @return Request
     */
    public function setRoleName($roleName)
    {
        $this->roleName = $roleName;

        return $this;
    }

    /**
     * @return string
     */
    public function getApplicationName()
    {
        return $this->applicationName;
    }

    /**
     * @param string $applicationName
     * @return Request
     */
    public function setApplicationName($applicationName)
    {
        $this->applicationName = $applicationName;

        return $this;
    }
}
