<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\User\Delete;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("userDelete")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version1\User\Delete
 */
class Request
{
    /**
     * @Serializer\SerializedName("users")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\UserWs\Version1\User\Delete\UserType>")
     * @Serializer\XmlList(entry="userType")
     *
     * @Assert\NotNull()
     * @Assert\Valid
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     *
     * @var UserType[]|ArrayCollection
     */
    protected $userTypes;

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->userTypes = new ArrayCollection();
    }

    /**
     * @return UserType[]|ArrayCollection
     */
    public function getUserTypes()
    {
        return $this->userTypes;
    }

    /**
     * @param UserType $userType
     *
     * @return $this
     */
    public function addUserType(UserType $userType)
    {
        if (!$this->userTypes->contains($userType)) {
            $this->userTypes->add($userType);
        }

        return $this;
    }
}
