<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Add;

use Sso\RestBundle\ModelRest\Common\Type\ArrayStringType;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeType
 *
 * @Serializer\XmlRoot("attributeType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Add
 */
class AttributeType
{
    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("type")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $type;

    /**
     * @Serializer\SerializedName("value")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Common\Type\ArrayStringType")
     * @Serializer\Accessor(setter="setValueFromObject", getter="getValueAsObject")
     * @Serializer\XmlList(inline=true, entry="value")
     *
     * @var string|array
     */
    private $value;

    /**
     * @Serializer\SerializedName("userType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Add\UserType")
     *
     * @var UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("applicationType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Add\ApplicationType")
     *
     * @var ApplicationType
     */
    private $applicationType;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AttributeType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return AttributeType
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * @return string|array
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param string|array $value
     * @return AttributeType
     */
    public function setValue($value)
    {
        $this->value = $value;

        return $this;
    }

    /**
     * @param ArrayStringType $value
     */
    public function setValueFromObject(ArrayStringType $value)
    {
        $this->value = $value->getValue();
    }

    /**
     * @return ArrayStringType
     */
    public function getValueAsObject()
    {
        return null !== $this->value ? new ArrayStringType($this->value) : null;
    }

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     * @return AttributeType
     */
    public function setUserType(UserType $userType)
    {
        $this->userType = $userType;

        return $this;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType $applicationType
     * @return AttributeType
     */
    public function setApplicationType(ApplicationType $applicationType)
    {
        $this->applicationType = $applicationType;

        return $this;
    }
}
