<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Add;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Serializer\XmlRoot("userAttributeAdd")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Add
 */
class Request
{
    /**
     * @Serializer\SerializedName("userAttributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Add\AttributeType>")
     * @Serializer\XmlList(entry="attributeType")
     *
     * @var AttributeType[]|ArrayCollection
     */
    protected $attributeType;

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->attributeType = new ArrayCollection();
    }

    /**
     * @return AttributeType[]|ArrayCollection
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param AttributeType $attributeType
     * @return Request
     */
    public function setAttributeType(AttributeType $attributeType)
    {
        if (!$this->attributeType->contains($attributeType)) {
            $this->attributeType->add($attributeType);
        }

        return $this;
    }
}
