<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Add;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("userApplicationRoleAdd")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Add
 */
class Request
{
    /**
     * @Serializer\SerializedName("userRoles")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Add\RoleType>")
     * @Serializer\XmlList(entry="roleType")
     *
     * @var RoleType[]|ArrayCollection
     */
    protected $roleTypes = [];

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->roleTypes = new ArrayCollection();
    }

    /**
     * @return RoleType[]|ArrayCollection
     */
    public function getRoleTypes()
    {
        return $this->roleTypes;
    }

    /**
     * @param RoleType $roleType
     *
     * @return $this
     */
    public function addRoleType(RoleType $roleType)
    {
        if (!$this->roleTypes->contains($roleType)) {
            $this->roleTypes->add($roleType);
        }

        return $this;
    }
}
