<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Delete;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("userApplicationRoleDelete")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Delete
 */
class Request
{
    /**
     * @Serializer\SerializedName("userApplicationRoles")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Delete\UserApplicationRoleType>")
     * @Serializer\XmlList(entry="userApplicationRoleType")
     *
     * @Assert\NotNull()
     * @Assert\Valid
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     *
     * @var UserApplicationRoleType[]|ArrayCollection
     */
    protected $userApplicationRoleTypes;

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->userApplicationRoleTypes = new ArrayCollection();
    }

    /**
     * @return UserApplicationRoleType[]|ArrayCollection
     */
    public function getUserApplicationRoleTypes()
    {
        return $this->userApplicationRoleTypes;
    }

    /**
     * @param UserApplicationRoleType $userType
     */
    public function addUserApplicationRoleType(UserApplicationRoleType $userApplicationRoleType)
    {
        if (!$this->userApplicationRoleTypes->contains($userApplicationRoleType)) {
            $this->userApplicationRoleTypes->add($userApplicationRoleType);
        }
    }
}
