<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordConfirm;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("userServicePasswordConfirm")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordConfirm
 */
class Request
{
    /**
     * @Serializer\SerializedName("userPasswordConfirm")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordConfirm\UserPasswordConfirm")
     *
     * @var UserPasswordConfirm
     */
    private $userPasswordConfirm;

    /**
     * @return UserPasswordConfirm
     */
    public function getUserPasswordConfirm()
    {
        return $this->userPasswordConfirm;
    }

    /**
     * @param UserPasswordConfirm $userPasswordConfirm
     * @return Request
     */
    public function setUserPasswordConfirm(UserPasswordConfirm $userPasswordConfirm)
    {
        $this->userPasswordConfirm = $userPasswordConfirm;

        return $this;
    }
}
