<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\User\Add;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("userAdd")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\User\Add
 */
class Request
{
    /**
     * @Serializer\SerializedName("users")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\UserWs\Version2\User\Add\UserType>")
     * @Serializer\XmlList(entry="userType")
     *
     * @Assert\NotNull()
     * @Assert\Valid
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     *
     * @var UserType[]|ArrayCollection
     */
    protected $userType;

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->userType = new ArrayCollection();
    }

    /**
     * @return UserType[]|ArrayCollection
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType |ArrayCollection
     */
    public function addUserType(UserType $userType)
    {
        if (!$this->userType->contains($userType)) {
            $this->userType->add($userType);
        }
    }
}
