<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("userSearchByApplication")
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication
 */
class Request
{
    /**
     * @Serializer\SerializedName("userByApplication")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication\UserByApplication")
     *
     * @var UserByApplication
     */
    private $userByApplication;

    /**
     * @return UserByApplication
     */
    public function getUserByApplication()
    {
        return $this->userByApplication;
    }

    /**
     * @param UserByApplication $userByApplication
     * @return Request
     */
    public function setUserByApplication(UserByApplication $userByApplication)
    {
        $this->userByApplication = $userByApplication;

        return $this;
    }
}
