<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("userByApplication")
 *
 * Class UserType
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication
 */
class UserType
{
    /**
     * @Serializer\SerializedName("modified")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $modified;

    /**
     * @Serializer\SerializedName("applicationType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication\ApplicationType")
     *
     * @var ApplicationType
     */
    private $applicationType;

    /**
     * @return string
     */
    public function getModified()
    {
        return $this->modified;
    }

    /**
     * @param string $modified
     * @return UserType
     */
    public function setModified($modified)
    {
        $this->modified = $modified;

        return $this;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType $applicationType
     * @return UserType
     */
    public function setApplicationType($applicationType)
    {
        $this->applicationType = $applicationType;

        return $this;
    }
}
