<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("userSearchByAttribute")
 *
 * Class UserByAttribute
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute
 */
class UserByAttribute
{
    /**
     * @Serializer\SerializedName("userType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\UserType")
     *
     * @var UserType
     */
    private $userType;

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     * @return UserByAttribute
     */
    public function setUserType(UserType $userType)
    {
        $this->userType = $userType;

        return $this;
    }
}
