<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\Common;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ResponseHead
 * @package Sso\RestBundle\ModelRest\Response\Common
 */
trait ResponseHead
{
    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $code;

    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @var integer
     */
    private $status;

    /**
     * optional message
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("date")
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     * @var string
     */
    private $date;

    /**
     * @Serializer\SerializedName("scriptTimeSec")
     * @Serializer\Type("double")
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @Serializer\Exclude()
     * @var array
     */
    private $codeStatus = [
        200 => 'OK',
        204 => 'No Content',
        400 => 'Bad Request',
        404 => 'Not Found',
        401 => 'Forbidden',
        500 => 'Internal Server Error',
    ];

    /**
     * @param int $code
     * @return ResponseHead
     */
    public function setCode($code)
    {
        $this->code = (int)$code;
        if (array_key_exists($code, $this->codeStatus)) {
            $this->status = $this->codeStatus[$code];
        } else {
            $this->code = 500;
            $this->status = "Internal Server Error";
        }

        return $this;
    }

    /**
     * @param string $message
     * @return ResponseHead
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @param string $trackId
     * @return ResponseHead
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @param string $date
     * @return ResponseHead
     */
    public function setDate($date)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * @param float $scriptTimeSec
     * @return ResponseHead
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;

        return $this;
    }

    /**
     * @param int $status
     * @return ResponseHead
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }
}
