<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\IdpWs\ServiceUser\Get;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserIdentifier
 * @package Sso\RestBundle\ModelRest\Response\IdpWs\ServiceUser\Get
 */
final class UserIdentifier
{
    /**
     * code
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $code;

    /**
     * status for code
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * optional message
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     * @var string
     */
    private $message;

    /**
     * trackId for debug
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     * @var string
     */
    private $trackId;

    /**
     * complete request loop
     * @Serializer\SerializedName("scriptTimeSec")
     * @Serializer\Type("double")
     * @var double
     */
    private $scriptTimeSec;

    /**
     * your useridentifier
     * @Serializer\SerializedName("userIdentifier")
     * @Serializer\Type("string")
     * @var string
     */
    private $userIdentifier;

    /**
     * session life time
     * @Serializer\SerializedName("sessionLifeTime")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $sessionLifeTime;

    /**
     * @param int $code
     * @return UserIdentifier
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $status
     * @return UserIdentifier
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @param string $message
     * @return UserIdentifier
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @param string $trackId
     * @return UserIdentifier
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @param float $scriptTimeSec
     * @return UserIdentifier
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;

        return $this;
    }

    /**
     * @param string $userIdentifier
     * @return UserIdentifier
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;

        return $this;
    }

    /**
     * @param \DateTime $sessionLifeTime
     * @return UserIdentifier
     */
    public function setSessionLifeTime($sessionLifeTime)
    {
        $this->sessionLifeTime = $sessionLifeTime;

        return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }

    /**
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }

    /**
     * @return \DateTime
     */
    public function getSessionLifeTime()
    {
        return $this->sessionLifeTime;
    }
}
