<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\IdpWs\ServiceUser\Validate;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserIdentifier
 * @package Sso\RestBundle\ModelRest\Response\IdpWs\ServiceUser\Validate
 */
class UserIdentifier
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $status;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("userIdentifier")
     * @Serializer\Type("string")
     * @var string
     */
    private $userIdentifier;

    /**
     * @Serializer\SerializedName("sessionLifeTime")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $sessionLifeTime;

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }

    /**
     * @return \DateTime
     */
    public function getSessionLifeTime()
    {
        return $this->sessionLifeTime;
    }

    /**
     * @param int $status
     * @return UserIdentifier
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @param string $message
     * @return UserIdentifier
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @param string $trackId
     * @return UserIdentifier
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @param string $userIdentifier
     * @return UserIdentifier
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;

        return $this;
    }

    /**
     * @param \DateTime $sessionLifeTime
     * @return UserIdentifier
     */
    public function setSessionLifeTime($sessionLifeTime)
    {
        $this->sessionLifeTime = $sessionLifeTime;

        return $this;
    }
}
