<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\MultipleWs\Version1\Object\Scope\Tree\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;
use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;

/**
 * Class Response
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "message", "trackId", "date", "scriptTimeSec"})
 * @Serializer\XmlRoot("scopeObjectTreeView")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\MultipleWs\Version1\Object\Scope\Tree\Success
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("string")
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("offset")
     * @Serializer\Type("string")
     * @var int
     */
    private $offset;

    /**
     * @Serializer\SerializedName("limit")
     * @Serializer\Type("string")
     * @var int
     */
    private $limit;

    /**
     * @Serializer\SerializedName("scopeTree")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\MultipleWs\Version1\Object\Scope\Tree\Success\ObjectType>")
     * @Serializer\XmlList(inline=true, entry="scopeTree")
     * @var ArrayCollection
     */
    private $objects;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->objects = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param string $count
     * @return Response
     */
    public function setCount($count)
    {
        $this->count = $count;

        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return Response
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return Response
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @return ArrayCollection|ObjectType[]
     */
    public function getObjects()
    {
        return $this->objects;
    }

    /**
     * @param ObjectType $object
     * @return $this
     */
    public function addObject($object)
    {
        if (!$this->objects->contains($object)) {
            $this->objects->add($object);
        }

        return $this;
    }
}
