<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Show;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Show
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Response
     */
    public function response()
    {
        return new Response();
    }

    /**
     * @return AttributeType
     */
    public function attributeType()
    {
        return new AttributeType();
    }

    /**
     * @return ErrorCollector\Error
     */
    public function error()
    {
        return new ErrorCollector\Error();
    }
}
