<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Show;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Show
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("offset")
     * @Serializer\Type("string")
     *
     * @var int
     */
    private $offset;

    /**
     * @Serializer\SerializedName("limit")
     * @Serializer\Type("string")
     *
     * @var int
     */
    private $limit;

    /**
     * @Serializer\SerializedName("attributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Show\AttributeType>")
     * @Serializer\XmlList(entry="attribute", inline=true)
     *
     * @var ArrayCollection|AttributeType[]
     */
    private $attributes;

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param string $count
     * @return Response
     */
    public function setCount($count)
    {
        $this->count = $count;

        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return Response
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return Response
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @return ArrayCollection|AttributeType[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @param AttributeType $attribute
     * @return Response
     */
    public function setAttributeType(AttributeType $attribute)
    {
        if (!$this->attributes) {
            $this->attributes = new ArrayCollection();
        }

        if (!$this->attributes->contains($attribute)) {
            $this->attributes->add($attribute);
        }

        return $this;
    }
}
