<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete
 */
class Error
{
    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("code")
     */
    private $code;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     */
    private $message;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("type")
     */
    private $type;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("exception")
     */
    private $exception;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("debug")
     */
    private $debug;

    /**
     * @param string $code
     * @return $this
     */
    public function setCode($code)
    {
        $this->code = (int)$code;

        return $this;
    }

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $message
     * @return $this
     */
    public function setMessage($message)
    {
        $this->message = (string)$message;

        return $this;
    }

    /**
     * Get message
     *
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->type = (string)$type;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $debug
     * @return $this
     */
    public function setDebug($debug)
    {
        $this->debug = (string)$debug;

        return $this;
    }

    /**
     * @return string
     */
    public function getDebug()
    {
        return $this->debug;
    }

    /**
     * @param string $exception
     */
    public function setException($exception)
    {
        $this->exception = (string)$exception;
    }

    /**
     * @return string
     */
    public function getException()
    {
        return $this->exception;
    }
}
