<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 *
 * @Serializer\XmlRoot("item")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete
 */
class Item
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @var string
     */
    protected $status;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $code;

    /**
     * @Serializer\SerializedName("scriptSeconds")
     * @Serializer\Type("double")
     *
     * @var double
     */
    protected $scriptSeconds;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @var string
     */
    protected $trackId;

    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @var string
     */
    protected $id;

    /**
     * @Serializer\SerializedName("error")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete\Errors")
     * @Serializer\XmlList(entry="error")
     *
     * @var Errors
     */
    protected $errors;

    /**
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     *
     * @param integer $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     *
     * @return Errors
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     *
     * @param Errors $errors
     */
    public function setErrors(Errors $errors)
    {
        $this->errors = $errors;
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return Item
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @param string $trackId
     * @return Item
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;
        return $this;
    }

    /**
     * @return integer
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param integer $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }


    /**
     * @return double
     */
    public function getScriptSeconds()
    {
        return $this->scriptSeconds;
    }

    /**
     * @param double $scriptSeconds
     */
    public function setScriptSeconds($scriptSeconds)
    {
        $this->scriptSeconds = $scriptSeconds;
    }
}
