<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Show\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\Api\Helper\Mapper\Index as Mapper;

/**
 * Class AttributeGroupType
 *
 * @Serializer\XmlRoot("Show")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Show\Success
 */
class AttributeGroupType
{
    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("integer")
     * @var int
     */
    private $count;

    /**
     * @Serializer\SerializedName("attributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Show\Success\Attribute>")
     * @Serializer\XmlList(entry="attribute")
     *
     * @var ArrayCollection
     */
    private $attributes;

    /**
     * @Serializer\Exclude()
     *
     * @var Mapper
     */
    private $mapper;

    /**
     * AttributeGroupType constructor.
     * @param Mapper $mapper
     */
    public function __construct(Mapper $mapper)
    {
        $this->mapper = $mapper;
        $this->attributes = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return AttributeGroupType
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AttributeGroupType
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param int $count
     * @return AttributeGroupType
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }

    /**
     * @param Attribute[] $attributes
     * @return AttributeGroupType
     */
    public function setAttributes($attributes)
    {
        $this->attributes = new ArrayCollection();
        foreach ($attributes as $attribute) {
            $this->attributes[] = $this->mapper->modelInToModelOut($attribute, new Attribute());
        }

        return $this;
    }

    /**
     * Get attributes
     *
     * @return Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
}
