<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Update;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;
use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeGroup
 *
 * @Serializer\XmlRoot("attributeGroups")
 * @Serializer\AccessorOrder("custom", custom={"code", "status"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Update
 */
class AttributeGroup
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("ids")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="id")
     *
     * @var ArrayCollection|string[]
     */
    private $typeIds;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var Error[]|ArrayCollection
     */
    private $errors;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return AttributeGroup
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AttributeGroup
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return ArrayCollection|string[]
     */
    public function getTypeIds()
    {
        return $this->typeIds;
    }

    /**
     * @param ArrayCollection|string[] $typeIds
     * @return AttributeGroup
     */
    public function setTypeIds($typeIds)
    {
        if (!empty($typeIds) && !$typeIds->isEmpty()) {
            $this->typeIds = $typeIds;
        }

        return $this;
    }

    /**
     * @param string $id
     * @return AttributeGroup
     */
    public function addTypeId($id)
    {
        if (!$this->typeIds) {
            $this->typeIds = new ArrayCollection();
        }

        if (!$this->typeIds->contains($id)) {
            $this->typeIds->add($id);
        }

        return $this;
    }


    /**
     * @return Error[]|ArrayCollection
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param Error $error
     * @return AttributeGroup
     */
    public function addError(Error $error)
    {
        // Prevent empty error array in success response
        if (!$this->errors) {
            $this->errors = new ArrayCollection();
        }

        if (!$this->errors->contains($error)) {
            $this->errors->add($error);
        }

        return $this;
    }
}
