<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Update;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("attributeGroupUpdate")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec", "attributeGroups"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Update
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("attributeGroups")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Update\AttributeGroup>")
     * @Serializer\XmlList(entry="attributeGroup")
     *
     * @var AttributeGroup[]|ArrayCollection
     */
    private $attributeGroups;

    /**
     * @return AttributeGroup[]|ArrayCollection
     */
    public function getAttributeGroups()
    {
        return $this->attributeGroups;
    }

    /**
     * @param AttributeGroup $attributeGroup
     * @return Response
     */
    public function addAttributeGroup(AttributeGroup $attributeGroup)
    {
        if (!$this->attributeGroups) {
            $this->attributeGroups = new ArrayCollection();
        }

        if (!$this->attributeGroups->contains($attributeGroup)) {
            $this->attributeGroups->add($attributeGroup);
        }

        return $this;
    }
}
