<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Language\Show\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Language\Show\Error
 */
class Error
{
    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("code")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $code;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("type")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $type;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("exception")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $exception;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("debug")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $debug;

    /**
     * Set code
     *
     * @param string $code
     * @return Error
     */
    public function setCode($code)
    {
        $this->code = (int)$code;

        return $this;
    }

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set message
     *
     * @param string $message
     *
     * @return Error
     */
    public function setMessage($message)
    {
        $this->message = (string)$message;

        return $this;
    }

    /**
     * Get message
     *
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return Error
     */
    public function setType($type)
    {
        $this->type = (string)$type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set debug
     *
     * @param string $debug
     * @return Error
     */
    public function setDebug($debug)
    {
        $this->debug = (string)$debug;

        return $this;
    }

    /**
     * Get debug
     *
     * @return string
     */
    public function getDebug()
    {
        return $this->debug;
    }

    /**
     *
     * @param string $exception
     * @return Error
     */
    public function setException($exception)
    {
        $this->exception = (string)$exception;

        return $this;
    }

    /**
     *
     * @return string
     */
    public function getException()
    {
        return $this->exception;
    }
}
