<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Multi\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Sso\RestBundle\Api\Helper\Mapper\Index as Mapper;

/**
 * Class Child
 *
 * @Serializer\XmlRoot("ShowMulti")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Multi\Success
 */
class Child
{
    /**
     * @Serializer\SerializedName("typeId")
     * @Serializer\Type("string")
     * @var string
     */
    private $typeGuid;

    /**
     * @Serializer\SerializedName("typeName")
     * @Serializer\Type("string")
     * @var string
     */
    private $typeName;

    /**
     * @Serializer\SerializedName("guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("referenceId")
     * @Serializer\Type("string")
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\SerializedName("parentGuid")
     * @Serializer\Type("string")
     * @var string
     */
    private $parentGuid;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("created")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $created;

    /**
     * @Serializer\SerializedName("updated")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $updated;

    /**
     * @Serializer\SerializedName("attributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Multi\Success\Attribute>")
     * @Serializer\XmlList(entry="attribute")
     *
     * @var ArrayCollection
     */
    private $attributes;

    /**
     * @Serializer\SerializedName("children")
     * @Serializer\XmlList(entry="objects")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Multi\Success\Child>")
     *
     * @var ArrayCollection
     */
    private $children;

    /**
     * @Serializer\Exclude()
     *
     * @var Mapper
     */
    private $mapper;

    /**
     * @Serializer\Exclude()
     *
     * @var string
     */
    private $requestedLangCode;

    /**
     * @param Mapper $mapper
     * @param string $requestedLangCode
     */
    public function __construct(Mapper $mapper, $requestedLangCode)
    {
        $this->mapper = $mapper;
        $this->requestedLangCode = $requestedLangCode;

        $this->children = new ArrayCollection();
        $this->attributes = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getTypeGuid()
    {
        return $this->typeGuid;
    }

    /**
     * @return string
     */
    public function getTypeName()
    {
        return $this->typeName;
    }

    /**
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param string $guid
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
    }

    /**
     * @param string $referenceId
     * @return Child
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;

        return $this;
    }

    /**
     * @param string $parentGuid
     * @return Child
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;

        return $this;
    }

    /**
     * @param string $typeGuid
     */
    public function setTypeGuid($typeGuid)
    {
        $this->typeGuid = $typeGuid;
    }

    /**
     * @param string $typeName
     * @return Child
     */
    public function setTypeName($typeName)
    {
        $this->typeName = $typeName;
        return $this;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @param \DateTime $created
     */
    public function setCreated($created)
    {
        $this->created = $created;
    }

    /**
     * @param \DateTime $updated
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
    }

    /**
     * Set children
     *
     * @param array $children
     * @return Child
     */
    public function setChildren($children)
    {
        $this->children = new ArrayCollection();
        foreach ($children as $child) {
            $this->children[] = $this->mapper->modelInToModelOut($child,
                new Child($this->mapper, $this->requestedLangCode));
        }

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * Set attributes
     *
     * @param Attribute[] $attributes
     * @return Child
     */
    public function setAttributes($attributes)
    {
        $this->attributes = new ArrayCollection();
        foreach ($attributes as $attribute) {

            // Show only attributes for requested language code
            if (null != $this->requestedLangCode && $this->requestedLangCode != $attribute->getLanguageCode()) {
                continue;
            }

            $this->attributes[] = $this->mapper->modelInToModelOut($attribute, new Attribute());
        }

        return $this;
    }

    /**
     * Get attributes
     *
     * @return Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
}
