<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Multi\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;
use Sso\RestBundle\Api\Helper\Mapper\Index as Mapper;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Multi\Success
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     * @var string
     */
    private $code;

    /**
     * @Serializer\SerializedName("scriptTime")
     * @Serializer\Type("string")
     * @var string
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("date")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $date;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("string")
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("offset")
     * @Serializer\Type("string")
     * @var int
     */
    private $offset;

    /**
     * @Serializer\SerializedName("limit")
     * @Serializer\Type("string")
     * @var int
     */
    private $limit;

    /**
     * @Serializer\SerializedName("objects")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Multi\Success\ObjectType>")
     * @Serializer\XmlList(inline=true, entry="objects")
     * @var ArrayCollection
     */
    private $objects;

    /**
     * @Serializer\Exclude()
     *
     * @var Mapper
     */
    private $mapper;

    public function __construct(Mapper $mapper)
    {
        $this->mapper = $mapper;

        $this->objects = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @return \Datetime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param string $Status
     * @return Response
     */
    public function setStatus($Status)
    {
        $this->Status = $Status;

        return $this;
    }

    /**
     * @param string $Trackid
     * @return Response
     */
    public function setTrackId($Trackid)
    {
        $this->trackId = $Trackid;

        return $this;
    }

    /**
     * @param string $Date
     * @return Response
     */
    public function setDate($Date)
    {
        $this->date = $Date;

        return $this;
    }

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param string $Count
     * @return Response
     */
    public function setCount($Count)
    {
        $this->count = $Count;

        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return Response
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return Response
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * Set objects
     *
     * @param ObjectType[] $objects
     * @return Response
     */
    public function setObjects($objects)
    {
        $this->objects = $objects;

        return $this;
    }

    /**
     * @param ObjectType $object
     * @return Response
     */
    public function addObject(ObjectType $object)
    {
        $this->objects->add($object);

        return $this;
    }

    /**
     * @return ObjectType[]
     */
    public function getObjects()
    {
        return $this->objects;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }

    /**
     * @return string
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param string $scriptTimeSec
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }
}
