<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Single\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\Api\Helper\Mapper\Index as Mapper;

/**
 * Class ObjectType
 *
 * @Serializer\XmlRoot("Show")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Single\Success
 */
class ObjectType
{
    /**
     * @Serializer\SerializedName("typeId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $typeGuid;

    /**
     * @Serializer\SerializedName("typeName")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $typeName;

    /**
     * @Serializer\SerializedName("typeOrder")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $typeOrder;

    /**
     * @Serializer\SerializedName("guid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("referenceId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\SerializedName("parentGuid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $parentGuid;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("created")
     * @Serializer\Type("DateTime")
     *
     * @var string
     */
    private $created;

    /**
     * @Serializer\SerializedName("updated")
     * @Serializer\Type("DateTime")
     *
     * @var string
     */
    private $updated;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $active;

    /**
     * @Serializer\SerializedName("attributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Single\Success\Attribute>")
     * @Serializer\XmlList(entry="attribute")
     *
     * @var ArrayCollection|Attribute[]
     */
    private $attributes;

    /**
     * @Serializer\Exclude()
     *
     * @var Mapper
     */
    private $mapper;

    /**
     * @Serializer\Exclude()
     *
     * @var string
     */
    private $requestedLangCode;

    /**
     * @param Mapper $mapper
     * @param $requestedLangCode
     */
    public function __construct(Mapper $mapper, $requestedLangCode)
    {
        $this->mapper = $mapper;
        $this->requestedLangCode = $requestedLangCode;

        $this->children = new ArrayCollection();
        $this->attributes = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getTypeGuid()
    {
        return $this->typeGuid;
    }

    /**
     * @param string $typeGuid
     * @return ObjectType
     */
    public function setTypeGuid($typeGuid)
    {
        $this->typeGuid = $typeGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeName()
    {
        return $this->typeName;
    }

    /**
     * @param string $typeName
     * @return ObjectType
     */
    public function setTypeName($typeName)
    {
        $this->typeName = $typeName;
        return $this;
    }

    /**
     * @return int
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

    /**
     * @param int $typeOrder
     * @return ObjectType
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;
        return $this;
    }

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     * @return ObjectType
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return ObjectType
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;
        return $this;
    }

    /**
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * @param string $parentGuid
     * @return ObjectType
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ObjectType
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param string $created
     * @return ObjectType
     */
    public function setCreated($created)
    {
        $this->created = $created;
        return $this;
    }

    /**
     * @return string
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param string $updated
     * @return ObjectType
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        return $this;
    }

    /**
     * @return int
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param int $active
     * @return ObjectType
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * @param ArrayCollection|Attribute[] $attributes
     * @return ObjectType
     */
    public function setAttributes($attributes)
    {
        $this->attributes = new ArrayCollection();
        foreach ($attributes as $attribute) {

            // Show only attributes for requested language code
            if (null != $this->requestedLangCode && $this->requestedLangCode != $attribute->getLanguageCode()) {
                continue;
            }

            $this->attributes[] = $this->mapper->modelInToModelOut($attribute, new Attribute());
        }

        return $this;
    }

    /**
     * Get attributes
     *
     * @return ArrayCollection|Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
}
