<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Tree\Error;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("response")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "message", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Tree\Error
 */
class Response
{
    use ResponseHead;
    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("count")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $count;

    /**
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Tree\Error\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var ArrayCollection
     */
    private $errors;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->errors = new ArrayCollection();
        $this->count = 0;

    }

    /**
     * count + 1
     */
    public function addCount()
    {
        $this->count++;
    }

    /**
     * count - 1
     */
    public function removeCount()
    {
        $this->count--;
    }

    public function resetCount()
    {
        $this->count = 0;
    }

    /**
     * @param Error[] $errors
     * @return Response
     */
    public function setError($errors)
    {
        $this->errors = new ArrayCollection();
        $this->resetCount();

        foreach ($errors as $error) {
            $this->addError($error);
        }

        return $this;
    }

    /**
     * @param Error $error
     * @return Response
     */
    public function addError(Error $error)
    {
        $this->errors[] = $error;
        $this->addCount();
        return $this;
    }

    /**
     * @param Error $error
     */
    public function removeError(Error $error)
    {
        $this->errors->removeElement($error);
        $this->removeCount();
    }

    /**
     * Get Errors
     *
     * @return Error[]
     */
    public function getError()
    {
        return $this->errors;
    }

    /**
     * @return boolean
     */
    public function hasErrors()
    {
        return 0 < $this->count;
    }

    /**
     * @return integer
     */
    public function getErrorsCount()
    {
        return $this->count;
    }
}
