<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Update;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("objectUpdate")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @package Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Update
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("objects")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Update\Object>")
     * @Serializer\XmlList(entry="object")
     *
     * @var Object[]|ArrayCollection
     */
    private $objects;

    /**
     * @return Object[]|ArrayCollection
     */
    public function getObjects()
    {
        return $this->objects;
    }

    /**
     * @param Object $object
     * @return Response
     */
    public function setObject(Object $object)
    {
        if (!$this->objects) {
            $this->objects = new ArrayCollection();
        }
        if (!$this->objects->contains($object)) {
            $this->objects->add($object);
        }

        return $this;
    }
}
