<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class Error
{
    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("code")
     */
    private $code;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     */
    private $message;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("type")
     */
    private $type;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("exception")
     */
    private $exception;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("debug")
     */
    private $debug;

    /**
     * Set code
     *
     * @param string $code
     *
     * @return Errors
     */
    public function setCode($code)
    {
        $this->code = (int)$code;

        return $this;
    }

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set message
     *
     * @param string $message
     *
     * @return Errors
     */
    public function setMessage($message)
    {
        $this->message = (string)$message;

        return $this;
    }

    /**
     * Get message
     *
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * Set type
     *
     * @param string $type
     *
     * @return Errors
     */
    public function setType($type)
    {
        $this->type = (string)$type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set debug
     *
     * @param string $debug
     *
     * @return Errors
     */
    public function setDebug($debug)
    {
        $this->debug = (string)$debug;

        return $this;
    }

    /**
     * Get debug
     *
     * @return string
     */
    public function getDebug()
    {
        return $this->debug;
    }

    /**
     * @param string $exception
     */
    public function setException($exception)
    {
        $this->exception = (string)$exception;
    }

    /**
     * @return string
     */
    public function getException()
    {
        return $this->exception;
    }
}
