<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Show\Success;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;
use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeType
 *
 * @Serializer\XmlRoot("attributes")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Show\Success
 */
class AttributeType
{
    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("mandatory")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $mandatory;

    /**
     * @Serializer\SerializedName("possibleValues")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="value")
     *
     * @var ArrayCollection|string[]
     */
    private $possibleValues;

    /**
     * @Serializer\SerializedName("defaultValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $defaultValue;

    /**
     * @Serializer\SerializedName("translatable")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $translatable;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return AttributeType
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AttributeType
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }

    /**
     * @param int $mandatory
     * @return AttributeType
     */
    public function setMandatory($mandatory)
    {
        $this->mandatory = $mandatory;
        return $this;
    }

    /**
     * @return ArrayCollection|string[]
     */
    public function getPossibleValues()
    {
        return $this->possibleValues;
    }

    /**
     * @param ArrayCollection|string[] $possibleValues
     * @return AttributeType
     */
    public function setPossibleValues($possibleValues)
    {
        $this->possibleValues = $possibleValues;

        return $this;
    }

    /**
     * @return string
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }

    /**
     * @param string $defaultValue
     * @return AttributeType
     */
    public function setDefaultValue($defaultValue)
    {
        $this->defaultValue = $defaultValue;
        return $this;
    }

    /**
     * @return int
     */
    public function getTranslatable()
    {
        return $this->translatable;
    }

    /**
     * @param int $translatable
     * @return AttributeType
     */
    public function setTranslatable($translatable)
    {
        $this->translatable = $translatable;
        return $this;
    }
}
