<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Add;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Errors
 *
 * @Serializer\XmlRoot("response")
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Add
 */
class Errors
{
    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("status")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("code")
     *
     * @var integer
     */
    private $code;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("scriptTimeSec")
     *
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("trackid")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("count")
     *
     * @var string
     */
    private $count;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Add\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var ArrayCollection
     */
    private $errors;

    /**
     * @var array
     */
    private $statusMessages;

    public function __construct()
    {
        $this->errors = new ArrayCollection();
        $this->count = 0;
        $this->statusMessages = [
            200 => 'OK',
            204 => 'No Content',
            400 => 'Bad Request',
            401 => 'Forbidden',
            500 => 'Internal Server Error',
        ];
    }

    /**
     * @param integer $status
     */
    public function setStatus($status)
    {
        $this->status = (int)$status;
        if (isset($this->statusMessages[$status])) {
            $this->message = $this->statusMessages[$status];
        } else {
            $this->message = 'Not Found';
        }
    }

    /**
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * count + 1
     */
    public function addCount()
    {
        $this->count++;
    }

    /**
     * count - 1
     */
    public function removeCount()
    {
        $this->count--;
    }

    /**
     * @param Error $error
     * @return Errors
     */
    public function addError(Error $error)
    {
        $this->errors[] = $error;
        $this->addCount();
        return $this;
    }

    /**
     * @param Error $error
     */
    public function removeError(Error $error)
    {
        $this->errors->removeElement($error);
        $this->removeCount();
    }

    /**
     * Get Errors
     *
     * @return Error[]
     */
    public function getError()
    {
        return $this->errors;
    }

    /**
     * @return boolean
     */
    public function hasErrors()
    {
        return 0 < $this->count;
    }

    /**
     * @return integer
     */
    public function getErrorsCount()
    {
        return $this->count;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $trackId
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }
}
