<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Add;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 *
 * @Serializer\XmlRoot("item")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Add
 */
class Item
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $code;

    /**
     * @Serializer\SerializedName("scriptTimeSec")
     * @Serializer\Type("double")
     *
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("objectGuid")
     *
     * @var string
     */
    private $objectGuid;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("objectName")
     *
     * @var string
     */
    private $objectName;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("attributeId")
     *
     * @var string
     */
    private $attributeId;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("attributeName")
     *
     * @var string
     */
    private $attributeName;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("id")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("value")
     *
     * @var string
     */
    private $value;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("languageCode")
     *
     * @var string
     */
    private $languageCode;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("created")
     *
     * @var \DateTime
     */
    private $created;

    /**
     * @Serializer\Expose
     * @Serializer\Type("DateTime")
     * @Serializer\SerializedName("updated")
     *
     * @var \DateTime
     */
    private $updated;

    /**
     * @Serializer\SerializedName("error")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Add\Errors")
     * @Serializer\XmlList(entry="error")
     *
     * @var Errors
     */
    private $errors;

    /**
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param integer $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @return string
     */
    public function getObjectGuid()
    {
        return $this->objectGuid;
    }

    /**
     * @param string $objectGuid
     * @return Item
     */
    public function setObjectGuid($objectGuid)
    {
        $this->objectGuid = $objectGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getObjectName()
    {
        return $this->objectName;
    }

    /**
     * @param string $objectName
     * @return Item
     */
    public function setObjectName($objectName)
    {
        $this->objectName = $objectName;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param string $attributeId
     * @return Item
     */
    public function setAttributeId($attributeId)
    {
        $this->attributeId = $attributeId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }

    /**
     * @param string $attributeName
     * @return Item
     */
    public function setAttributeName($attributeName)
    {
        $this->attributeName = $attributeName;
        return $this;
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return Item
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return Item
     */
    public function setValue($value)
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @param string $languageCode
     * @return Item
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param \DateTime $updated
     * @return Item
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        return $this;
    }

    /**
     * @return Errors
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param Errors $errors
     */
    public function setErrors(Errors $errors)
    {
        $this->errors = $errors;
    }

    /**
     * @return \DateTime
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @param string $order
     */
    public function setOrder($order)
    {
        $this->order = $order;
    }

    /**
     * @return string
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param string $created
     */
    public function setCreated($created)
    {
        $this->created = $created;
    }


    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }
}
