<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Show\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\Api\Helper\Mapper\Index as Mapper;

/**
 * Class ObjectValueType
 *
 * @Serializer\XmlRoot("Show")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Show\Success
 */
class ObjectValueType
{
    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("value")
     * @Serializer\Type("string")
     * @var string
     */
    private $value;

    /**
     * @Serializer\SerializedName("languageCode")
     * @Serializer\Type("string")
     * @var string
     */
    private $languageCode;

    /**
     * @Serializer\SerializedName("objectGuid")
     * @Serializer\Type("string")
     * @var string
     */
    private $objectGuid;

    /**
     * @Serializer\SerializedName("objectName")
     * @Serializer\Type("string")
     * @var string
     */
    private $objectName;

    /**
     * @Serializer\SerializedName("attributeId")
     * @Serializer\Type("string")
     * @var string
     */
    private $attributeId;

    /**
     * @Serializer\SerializedName("attributeName")
     * @Serializer\Type("string")
     * @var string
     */
    private $attributeName;

    /**
     * @Serializer\SerializedName("created")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $created;

    /**
     * @Serializer\SerializedName("updated")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $updated;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return ObjectValueType
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param string $value
     * @return ObjectValueType
     */
    public function setValue($value)
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @param string $languageCode
     * @return ObjectValueType
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getObjectGuid()
    {
        return $this->objectGuid;
    }

    /**
     * @param string $objectGuid
     * @return ObjectValueType
     */
    public function setObjectGuid($objectGuid)
    {
        $this->objectGuid = $objectGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getObjectName()
    {
        return $this->objectName;
    }

    /**
     * @param string $objectName
     * @return ObjectValueType
     */
    public function setObjectName($objectName)
    {
        $this->objectName = $objectName;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param string $attributeId
     * @return ObjectValueType
     */
    public function setAttributeId($attributeId)
    {
        $this->attributeId = $attributeId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }

    /**
     * @param string $attributeName
     * @return ObjectValueType
     */
    public function setAttributeName($attributeName)
    {
        $this->attributeName = $attributeName;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param \DateTime $created
     * @return ObjectValueType
     */
    public function setCreated($created)
    {
        $this->created = $created;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param \DateTime $updated
     * @return ObjectValueType
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        return $this;
    }
}
