<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Show\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Show\Success
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $Code;

    /**
     * @Serializer\SerializedName("scriptTimeSec")
     * @Serializer\Type("double")
     * @var double
     */
    private $ScriptTimeSec;

    /**
     * @Serializer\SerializedName("trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $Trackid;

    /**
     * @Serializer\SerializedName("date")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $Date;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("string")
     * @var string
     */
    private $Count;

    /**
     * @Serializer\SerializedName("offset")
     * @Serializer\Type("string")
     * @var int
     */
    private $offset;

    /**
     * @Serializer\SerializedName("limit")
     * @Serializer\Type("string")
     * @var int
     */
    private $limit;

    /**
     * @Serializer\SerializedName("objectValues")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Show\Success\ObjectValueType>")
     * @Serializer\XmlList(inline=true, entry="objectValues")
     * @var ArrayCollection
     */
    private $objectValues;

    public function __construct()
    {
        $this->objectValues = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @return string
     */
    public function getTrackid()
    {
        return $this->Trackid;
    }

    /**
     * @return datetime
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * @param string $Status
     * @return Response
     */
    public function setStatus($Status)
    {
        $this->Status = $Status;

        return $this;
    }

    /**
     * @param string $Trackid
     * @return Response
     */
    public function setTrackid($Trackid)
    {
        $this->Trackid = $Trackid;

        return $this;
    }

    /**
     * @param string $Date
     * @return Response
     */
    public function setDate($Date)
    {
        $this->Date = $Date;

        return $this;
    }

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->Count;
    }

    /**
     * @param string $Count
     * @return Response
     */
    public function setCount($Count)
    {
        $this->Count = $Count;

        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return Response
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return Response
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @param ObjectValueType $objectValue
     * @return Response
     */
    public function addObjectValue(ObjectValueType $objectValue)
    {
        $this->objectValues->add($objectValue);

        return $this;
    }

    /**
     * @return ObjectValueType[]
     */
    public function getObjectValues()
    {
        return $this->objectValues;
    }


    /**
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }

    /**
     * @param int $Code
     */
    public function setCode($Code)
    {
        $this->Code = $Code;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->ScriptTimeSec;
    }

    /**
     * @param float $ScriptTimeSec
     */
    public function setScriptTimeSec($ScriptTimeSec)
    {
        $this->ScriptTimeSec = $ScriptTimeSec;
    }
}
