<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Update;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("objectValueUpdate")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Update
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("objectValue")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectValue\Update\ObjectValueType>")
     * @Serializer\XmlList(entry="objectValueType")
     *
     * @var ObjectValueType[]|ArrayCollection
     */
    private $objectValueType;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->objectValueType = new ArrayCollection();
    }

    /**
     * @return ObjectValueType[]|ArrayCollection
     */
    public function getObjectValueType()
    {
        return $this->objectValueType;
    }

    /**
     * @param ObjectValueType $objectValueType
     */
    public function addObjectValueType(ObjectValueType $objectValueType)
    {
        if (!$this->objectValueType->contains($objectValueType)) {
            $this->objectValueType->add($objectValueType);
        }
    }
}
