<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\ApplicationAttribute\Add;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("applicationAttributeAdd")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\ApplicationAttribute\Add
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("attributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version1\ApplicationAttribute\Add\AttributeType>")
     * @Serializer\XmlList(entry="attributeType")
     *
     * @var AttributeType[]|ArrayCollection
     */
    private $attributeType;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->attributeType = new ArrayCollection();
    }

    /**
     * @return AttributeType[]|ArrayCollection
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param AttributeType $attributeType
     */
    public function addAttributeType(AttributeType $attributeType)
    {
        if (!$this->attributeType->contains($attributeType)) {
            $this->attributeType->add($attributeType);
        }
    }
}
