<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\ApplicationRole\Delete;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("applicationRoleDelete")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\ApplicationRole\Add
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("roles")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version1\ApplicationRole\Delete\RoleType>")
     * @Serializer\XmlList(entry="roleType")
     *
     * @var RoleType[]|ArrayCollection
     */
    private $roleType;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->roleType = new ArrayCollection();
    }

    /**
     * @return RoleType[]|ArrayCollection
     */
    public function getRoleType()
    {
        return $this->roleType;
    }

    /**
     * @param RoleType $roleType
     */
    public function addRoleType(RoleType $roleType)
    {
        if (!$this->roleType->contains($roleType)) {
            $this->roleType->add($roleType);
        }
    }
}
