<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\Attribute\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\Attribute\Delete
 */
class Error
{
    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("code")
     *
     * @var string
     */
    private $code;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("type")
     *
     * @var string
     */
    private $type;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("exception")
     *
     * @var string
     */
    private $exception;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("debug")
     *
     * @var string
     */
    private $debug;

    /**
     * Set code
     *
     * @param string $code
     * @return Errors
     */
    public function setCode($code)
    {
        $this->code = (int)$code;
        return $this;
    }

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set message
     *
     * @param string $message
     * @return Errors
     */
    public function setMessage($message)
    {
        $this->message = (string)$message;
        return $this;
    }

    /**
     * Get message
     *
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * Set type
     *
     * @param string $type
     * @return Errors
     */
    public function setType($type)
    {
        $this->type = (string)$type;
        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set debug
     *
     * @param string $debug
     * @return Errors
     */
    public function setDebug($debug)
    {
        $this->debug = (string)$debug;
        return $this;
    }

    /**
     * Get debug
     *
     * @return string
     */
    public function getDebug()
    {
        return $this->debug;
    }

    /**
     * @param string $exception
     */
    public function setException($exception)
    {
        $this->exception = (string)$exception;
    }

    /**
     * @return string
     */
    public function getException()
    {
        return $this->exception;
    }
}
