<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplication\Delete;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userApplicationDelete")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec", "users"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationAttribute\Delete
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("users")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplication\Delete\UserType>")
     * @Serializer\XmlList(entry="userType")
     *
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     *
     * @var UserType[]|ArrayCollection
     */
    protected $userType;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->userType = new ArrayCollection();
    }

    /**
     * @return UserType[]|ArrayCollection
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     */
    public function addUserType(UserType $userType)
    {
        if (!$this->userType->contains($userType)) {
            $this->userType->add($userType);
        }
    }
}
